<?php

/*
Plugin Name: WooCommerce Cart Set Subtotal to Total
Description: Gets the subtotal value in WooCommerce cart and sets it to total always to avoid rounding issues.
Author: Con Schneider
Author URI: http://conschneider.de
Version: 0.2
*/

if ( ! defined( 'ABSPATH' ) ) { 
    exit; // Exit if accessed directly
}

function wcc_set_subtotal_to_total ($total) 
{
	if (is_cart() || is_checkout())
	{
		$total = WC()->cart->get_total();
		$tax_label = WC()->tax->get_rate_label();
		return $total . $tax_label;
	}
}

add_filter('woocommerce_cart_subtotal', 'wcc_set_subtotal_to_total');