<?php
/**
 * @wordpress-plugin
 * Plugin Name:       WooCommerce Auto Save Products
 * Plugin URI:        #
 * Description:       This small plugin constantly auto saves product posts while you are active in wp-admin. Warning: This plugin may consume a lot of resources if you have a lot of products. Only keep activated when needed, for example when importing or doing bulk editing.
 * Version:           beta1.0.
 * Author:            Con Schneider
 * Author URI:        https://conschneider.de
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       woo-autosave-products
 * Domain Path:       /languages
 */

function update_all_products() {
    $args = array(
        'post_type' => 'product',
        'numberposts' => -1
    );
    $all_posts = get_posts($args);
    foreach ($all_posts as $single_post){
        wp_update_post( $single_post );
    }
}
add_action( 'wp_loaded', 'update_all_products' );