<?php
/*
Plugin Name: AutomateWoo Billing Trigger
Description: Adds custom triggers to AutomateWoo
Version: 1.0
Author: Your Name
Author URI: Your Website
License: GPLv2 or later
*/

class Con_Automatewoo_Triggers{

    private static $instance;

    public static function instance(){

        if ( ! self::$instance ){
            self::$instance = new Con_Automatewoo_Triggers();
            self::$instance->init();
        }

    } // instance

    public function init(){

        $this->constants();
        $this->includes();

        add_filter( 'automatewoo/triggers', array( $this, 'customer_updated_address_trigger' ), 10, 1 );

    } // init

    public static function customer_updated_address_trigger( $triggers ){

        require_once( 'trigger-customer-updated-address.php' );

        $triggers['customer_updated_address'] = 'Customer_Updated_Address_Trigger';

        return $triggers;

    }

    public function constants(){

        define( 'CON_AUTOMATEWOO_TRIGGERS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

    }

    public function includes(){
    }

} // Con_Automatewoo_Triggers

Con_Automatewoo_Triggers::instance();