<?php

if ( ! defined( 'ABSPATH' ) ){
	exit;
}

class Customer_Updated_Address_Trigger extends AutomateWoo\Trigger{

	public $supplied_data_items = array( 'customer' );

	public function init() {
		$this->title = __( 'Customer Updated Address', 'text-domain' );
		$this->group = __( 'Custom Triggers', 'text-domain' );
	}

	public function load_fields() {}

	public function register_hooks() {
		add_action( 'woocommerce_customer_save_address', array( $this, 'catch_hooks' ), 10, 2 );
	}

	public function catch_hooks( $user_id, $load_address ) {
		$customer = AutomateWoo\Customer_Factory::get_by_user_id( $user_id );
			
		$this->maybe_run(array(
			'customer' => $customer,
		));
	}

	public function validate_workflow( $workflow ) {
		$customer = $workflow->data_layer()->get_customer();

		// do something...

		return true;
	}

} // Customer_Updated_Address_Trigger