<?php

/**
 * Plugin Name: Display Current Server Date and Time
 * Description: Displays current server date and time on single product to keep track when troubleshooting timed events. 
 * Author: Con Schneider
 * Author URI: http://conschneider.de/
 * License: GPLv2 or later
 * Text Domain: wcdct-
 * Version: 0.3
 * Domain Path: /languages/
 */


if ( ! defined( 'ABSPATH' ) ) { 
    exit; // Exit if accessed directly
}




if(!class_exists('wcdct_Plugin_Main'))
{
	class wcdct_Plugin_Main
	{
		/**
		 * Construct the plugin object
		 */
		public function __construct()
		{
			add_action( 'woocommerce_single_product_summary', array( $this, 'display_current_server_time' ), 10);
			add_shortcode( 'wcdct_show_server_time', array( 'wcdct_Plugin_Main', 'display_current_server_time_shortcode' ) );
		} // END public function __construct
		
		public function display_current_server_time()
		{
			$get_the_time = current_time( 'Y-m-d - H:i:s' );
			
			if ( current_user_can('administrator') )
							{
								echo "<hr style='margin-bottom: 0.5em;'><strong>The current server date and time is: </strong><br>" . $get_the_time . "<hr style='margin-bottom: 1em;'>"; 
							}
		}
		
		public function display_current_server_time_shortcode()
		{
			$get_the_time = current_time( 'Y-m-d - H:i:s' );
			//need output to be lower priority so it appears in desired spot so concatenate and return instead of lazy echo ;). 
			$show_the_time = "<hr style='margin-bottom: 0.5em;'><strong>The current server date and time is: </strong><br>";
			$show_the_time .= $get_the_time;
			$show_the_time .= "<hr style='margin-bottom: 1em;'>";
			
			return $show_the_time;
		
		}
		
		/**
		 * Activate the plugin
		 */
		public static function activate()
		{
			// Do nothing
		} // END public static function activate
		/**
		 * Deactivate the plugin
		 */
		public static function deactivate()
		{
			// Do nothing
		} // END public static function deactivate
	}
	//add shortcode late, so it does not load too soon in the construct
	//add_shortcode( 'wcdct_show_server_time', array( 'wcdct_Plugin_Main', 'display_current_server_time_shortcode' ) );
}

if(class_exists('wcdct_Plugin_Main'))
{
	// Installation and uninstallation hooks
	register_activation_hook(__FILE__, array('wcdct_Plugin_Main', 'activate'));
	register_deactivation_hook(__FILE__, array('wcdct_Plugin_Main', 'deactivate'));
	// instantiate the plugin class
	$wcdct_Plugin_Main = new wcdct_Plugin_Main();
}
